/*
 * Decompiled with CFR 0.152.
 */
package azmalent.cuneiform.lib.config.data;

import azmalent.cuneiform.Cuneiform;
import azmalent.cuneiform.lib.config.data.LootConfigCondition;
import azmalent.cuneiform.lib.config.data.RecipeConfigCondition;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.loot.ILootSerializer;
import net.minecraft.loot.LootConditionType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.fml.ModList;

public final class ConfigFlagManager {
    public static LootConditionType LOOT_CONFIG_CONDITION = new LootConditionType((ILootSerializer)new LootConfigCondition.Serializer());
    public static final Map<String, Map<String, Boolean>> flagsByModid = new HashMap<String, Map<String, Boolean>>();

    public static void putFlag(ResourceLocation flag, boolean value) {
        String[] tokens = flag.toString().split(":", 2);
        ConfigFlagManager.putFlag(tokens[0], tokens[1], value);
    }

    public static void putFlag(String modid, String flag, boolean value) {
        if (!flagsByModid.containsKey(modid)) {
            flagsByModid.put(modid, new HashMap());
        }
        flagsByModid.get(modid).put(flag, value);
    }

    public static boolean getFlag(String modid, String flag) {
        Map<String, Boolean> modFlags;
        if (flagsByModid.containsKey(modid) && (modFlags = flagsByModid.get(modid)).containsKey(flag)) {
            return modFlags.get(flag);
        }
        if (ModList.get().isLoaded(modid)) {
            Cuneiform.LOGGER.warn(String.format("Unknown flag '%s:%s', defaulting to false", modid, flag));
        }
        return false;
    }

    static {
        ResourceLocation id = Cuneiform.prefix("config");
        CraftingHelper.register((IConditionSerializer)new RecipeConfigCondition.Serializer(id));
        Registry.func_218322_a((Registry)Registry.field_239704_ba_, (ResourceLocation)id, (Object)LOOT_CONFIG_CONDITION);
    }
}

